/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.thanos.forge;

import club.sk1er.mods.thanos.forge.RenderGlobalTransformer;
import club.sk1er.mods.thanos.forge.ThanosTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public final class ClassTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"ASM");
    private final Multimap<String, ThanosTransformer> transformerMap = ArrayListMultimap.create();

    public ClassTransformer() {
        this.registerTransformer(new RenderGlobalTransformer());
    }

    private void registerTransformer(ThanosTransformer transformer) {
        for (String cls : transformer.getClassNames()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        LOGGER.info("Found {} transformers for {}", new Object[]{transformers.size(), transformedName});
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        transformers.forEach(transformer -> transformer.transform(classNode, transformedName));
        ClassWriter classWriter = new ClassWriter(3);
        try {
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (Throwable e) {
            LOGGER.error("Exception when transforming {} : {}", new Object[]{transformedName, e.getClass().getSimpleName()});
            e.printStackTrace();
        }
        return classWriter.toByteArray();
    }
}

